Public Class CribbageBoard
    Inherits System.Windows.Forms.Form
    'This is a dippy cribbage scoring program
    'Features to be added:
    ' * Of course, pen capable!
    ' * Editable names, so other people can use it
    ' * The start and end holes
    ' * Pick the color of your peg

    'Declarations
    Private BillsLastTotal As Integer = 0
    Private GabriellesLastTotal As Integer = 0

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents BillsScore As System.Windows.Forms.TextBox
    Friend WithEvents GabriellesScore As System.Windows.Forms.TextBox
    Friend WithEvents Bill As System.Windows.Forms.Label
    Friend WithEvents Gabrielle As System.Windows.Forms.Label
    Friend WithEvents BillsPoints As System.Windows.Forms.Label
    Friend WithEvents GabriellesPoints As System.Windows.Forms.Label
    Friend WithEvents newGameButton As System.Windows.Forms.LinkLabel
    Friend WithEvents ScoreCheck As System.Windows.Forms.ErrorProvider
    Friend WithEvents WinMessage As System.Windows.Forms.Label
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(CribbageBoard))
        Me.Bill = New System.Windows.Forms.Label
        Me.Gabrielle = New System.Windows.Forms.Label
        Me.BillsScore = New System.Windows.Forms.TextBox
        Me.GabriellesScore = New System.Windows.Forms.TextBox
        Me.WinMessage = New System.Windows.Forms.Label
        Me.BillsPoints = New System.Windows.Forms.Label
        Me.GabriellesPoints = New System.Windows.Forms.Label
        Me.newGameButton = New System.Windows.Forms.LinkLabel
        Me.ScoreCheck = New System.Windows.Forms.ErrorProvider
        Me.SuspendLayout()
        '
        'Bill
        '
        Me.Bill.Location = New System.Drawing.Point(96, 224)
        Me.Bill.Name = "Bill"
        Me.Bill.Size = New System.Drawing.Size(24, 23)
        Me.Bill.TabIndex = 0
        Me.Bill.Text = "Bill"
        '
        'Gabrielle
        '
        Me.Gabrielle.Location = New System.Drawing.Point(656, 224)
        Me.Gabrielle.Name = "Gabrielle"
        Me.Gabrielle.Size = New System.Drawing.Size(56, 23)
        Me.Gabrielle.TabIndex = 1
        Me.Gabrielle.Text = "Gabrielle"
        '
        'BillsScore
        '
        Me.BillsScore.AutoSize = False
        Me.BillsScore.Location = New System.Drawing.Point(88, 256)
        Me.BillsScore.Name = "BillsScore"
        Me.BillsScore.TabIndex = 0
        Me.BillsScore.Text = ""
        '
        'GabriellesScore
        '
        Me.GabriellesScore.Location = New System.Drawing.Point(656, 256)
        Me.GabriellesScore.Name = "GabriellesScore"
        Me.GabriellesScore.TabIndex = 1
        Me.GabriellesScore.Text = ""
        '
        'WinMessage
        '
        Me.WinMessage.Location = New System.Drawing.Point(344, 232)
        Me.WinMessage.Name = "WinMessage"
        Me.WinMessage.Size = New System.Drawing.Size(168, 23)
        Me.WinMessage.TabIndex = 4
        Me.WinMessage.Text = "Somebody wins!"
        Me.WinMessage.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        Me.WinMessage.Visible = False
        '
        'BillsPoints
        '
        Me.BillsPoints.Location = New System.Drawing.Point(160, 224)
        Me.BillsPoints.Name = "BillsPoints"
        Me.BillsPoints.Size = New System.Drawing.Size(24, 23)
        Me.BillsPoints.TabIndex = 5
        Me.BillsPoints.Text = "0"
        Me.BillsPoints.TextAlign = System.Drawing.ContentAlignment.TopRight
        '
        'GabriellesPoints
        '
        Me.GabriellesPoints.Location = New System.Drawing.Point(720, 224)
        Me.GabriellesPoints.Name = "GabriellesPoints"
        Me.GabriellesPoints.Size = New System.Drawing.Size(32, 23)
        Me.GabriellesPoints.TabIndex = 6
        Me.GabriellesPoints.Text = "0"
        Me.GabriellesPoints.TextAlign = System.Drawing.ContentAlignment.TopRight
        '
        'newGameButton
        '
        Me.newGameButton.Location = New System.Drawing.Point(376, 264)
        Me.newGameButton.Name = "newGameButton"
        Me.newGameButton.TabIndex = 0
        Me.newGameButton.TabStop = True
        Me.newGameButton.Text = "New Game"
        Me.newGameButton.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'ScoreCheck
        '
        Me.ScoreCheck.BlinkStyle = System.Windows.Forms.ErrorBlinkStyle.NeverBlink
        Me.ScoreCheck.ContainerControl = Me
        '
        'CribbageBoard
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(862, 296)
        Me.Controls.Add(Me.newGameButton)
        Me.Controls.Add(Me.GabriellesPoints)
        Me.Controls.Add(Me.BillsPoints)
        Me.Controls.Add(Me.WinMessage)
        Me.Controls.Add(Me.GabriellesScore)
        Me.Controls.Add(Me.BillsScore)
        Me.Controls.Add(Me.Gabrielle)
        Me.Controls.Add(Me.Bill)
        Me.Icon = CType(resources.GetObject("$this.Icon"), System.Drawing.Icon)
        Me.MaximizeBox = False
        Me.MinimizeBox = False
        Me.Name = "CribbageBoard"
        Me.SizeGripStyle = System.Windows.Forms.SizeGripStyle.Hide
        Me.Text = "Sempf Cribbage"
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Sub BillsScore_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BillsScore.Leave
        BillsLastTotal = CInt(BillsPoints.Text)
        HandleScore(sender, BillsPoints, GabriellesPoints)
        PaintBoard(BillsPoints, GabriellesPoints)
        BillsScore.Text = String.Empty
    End Sub

    Private Sub GabriellesScore_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles GabriellesScore.Leave
        GabriellesLastTotal = CInt(GabriellesPoints.Text)
        HandleScore(sender, GabriellesPoints, BillsPoints)
        PaintBoard(BillsPoints, GabriellesPoints)
        GabriellesScore.Text = String.Empty
    End Sub
    Private Sub HandleScore(ByVal scoreBox As TextBox, ByVal points As Label, ByVal otherPlayer As Label)
        Try
            If 0 > CInt(scoreBox.Text) Or CInt(scoreBox.Text) > 27 Then
                ScoreCheck.SetError(scoreBox, "Score must be between 0 and 27")
                scoreBox.Focus()
            Else
                ScoreCheck.SetError(scoreBox, "")
                'Add the score written to the points
                points.Text = CInt(points.Text) + CInt(scoreBox.Text)
            End If
        Catch ext As System.InvalidCastException
            'Something other than a number
            If scoreBox.Text.Length > 0 Then
                ScoreCheck.SetError(scoreBox, "Score must be a number")
            End If
        Catch ex As Exception
            'Eek!
            MessageBox.Show("Something went wrong!  " + ex.Message)
        End Try
        'Check the score
        If CInt(points.Text) > 120 Then
            If CInt(points.Text) / CInt(otherPlayer.Text) > 1.5 Then
                WinMessage.Text = scoreBox.Name.Substring(0, scoreBox.Name.Length - 6) & " Skunked 'em!!!"
            Else
                WinMessage.Text = scoreBox.Name.Substring(0, scoreBox.Name.Length - 6) & " Won!!"
            End If
            WinMessage.Visible = True
        End If
    End Sub

    Private Sub newGameButton_LinkClicked(ByVal sender As System.Object, ByVal e As System.Windows.Forms.LinkLabelLinkClickedEventArgs) Handles newGameButton.LinkClicked
        BillsPoints.Text = 0
        BillsPoints.Focus()
        BillsScore.Text = 0
        GabriellesPoints.Text = 0
        GabriellesScore.Text = 0
        WinMessage.Visible = False
        PaintBoard(BillsPoints, GabriellesPoints)
    End Sub
    Private Sub PaintBoard(ByRef Bill As Label, ByRef Gabrielle As Label)
        Dim palette As Graphics = Me.CreateGraphics
        Dim brownBrush As New SolidBrush(Color.Brown)
        palette.FillRectangle(brownBrush, New Rectangle(20, 20, 820, 180))
        'OK, now I need to paint the little holes.
        'There are 244 little holes in the board.
        'Three rows of 40 times two, with the little starts and stops on either end.  
        'Let's start with the 240.
        Dim rows As Integer
        Dim columns As Integer
        Dim scoreBeingDrawn As Integer
        Dim blackPen As New Pen(System.Drawing.Color.Black, 1)
        Dim blackBrush As New SolidBrush(Color.Black)
        Dim redBrush As New SolidBrush(Color.Red)

        'There are 6 rows, then, at 24 and 40, 80 and 100, then 140 and 160.
        For rows = 40 To 160 Step 60
            'There are 40 columns.  they are every 20
            For columns = 40 To 820 Step 20
                'Calculate score being drawn
                scoreBeingDrawn = ((columns - 20) / 20) + ((((rows + 20) / 60) - 1) * 40)
                'Draw Bill
                'If score being drawn = bill fill, otherwise draw
                If scoreBeingDrawn = CInt(Bill.Text) Then
                    palette.FillEllipse(blackBrush, columns - 2, rows - 2, 6, 6)
                ElseIf scoreBeingDrawn = BillsLastTotal Then
                    palette.FillEllipse(redBrush, columns - 2, rows - 2, 6, 6)
                Else
                    palette.DrawEllipse(blackPen, columns - 2, rows - 2, 4, 4)
                End If
                'Draw Gab
                'If score being drawn = bill fill, otherwise draw
                If scoreBeingDrawn = CInt(Gabrielle.Text) Then
                    palette.FillEllipse(blackBrush, columns - 2, rows + 16, 6, 6)
                ElseIf scoreBeingDrawn = GabriellesLastTotal Then
                    palette.FillEllipse(redBrush, columns - 2, rows + 16, 6, 6)
                Else
                    palette.DrawEllipse(blackPen, columns - 2, rows + 16, 4, 4)
                End If
            Next
        Next
        palette.Dispose()
        brownBrush.Dispose()
        blackPen.Dispose()
    End Sub

    Private Sub CribbageBoard_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        newGameButton.TabStop = False
    End Sub

    Private Sub CribbageBoard_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles MyBase.Paint
        PaintBoard(BillsPoints, GabriellesPoints)
    End Sub
End Class
